/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.system.action;

import java.sql.SQLException;
import java.util.List;

import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.payroll.base.PayrollAction;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.dao.PmDetailPaDao;
import jp.mosp.payroll.dao.PmDetailPbDao;
import jp.mosp.payroll.dao.PmDetailPdDao;
import jp.mosp.payroll.dao.PmDetailPsDao;
import jp.mosp.payroll.dao.PmDetailPtDao;

import jp.mosp.payroll.bonus.dao.PmDetailBaDao;
import jp.mosp.payroll.bonus.dao.PmDetailBdDao;
import jp.mosp.payroll.bonus.dao.PmDetailBsDao;

import jp.mosp.payroll.system.vo.DetailListVo;

/**
 * אݒꗗʂɂ鏈sB<br><br>
 * ȉ̃R}hB
 * <ul><li>
 * {@link #CMD_SHOW}
 * </li><li>
 * {@link #CMD_SEARCH}
 * </li><li>
 * {@link #CMD_RE_SEARCH}
 * </li><li>
 * {@link #CMD_SORT}
 * </li><li>
 * {@link #CMD_PAGE}
 * </li></ul>
 */
public class DetailListAction extends PayrollAction {
	
	/**
	 * ʕ\R}hB<br><br>
	 * אݒꗗʂ\B<br>
	 */
	public static final String CMD_SHOW = "P7010";
	
	/**
	 * R}hB<br><br>
	 * w肳ꂽŖאݒ̌sAꗗ\B<br>
	 */
	public static final String CMD_SEARCH = "P7011";
	
	/**
	 * ČR}hB<br><br>
	 * ۑꂽŖאݒ̌sAꗗ\B<br>
	 */
	public static final String CMD_RE_SEARCH = "P7012";
	
	/**
	 * \[gR}hB<br><br>
	 * w肳ꂽŖאݒ̕בւsAꗗ\B<br>
	 */
	public static final String CMD_SORT = "P7013";
	
	/**
	 * y[WR}hB<br><br>
	 * w肳ꂽŖאݒ̃y[WJsAꗗ\B<br>
	 */
	public static final String CMD_PAGE = "P7014";
	
	/**
	 * Action̏sB<br><br>
	 * ȉ̏sB
	 * <ul><li>
	 * {@link PayrollAction#PayrollAction()}
	 * </li></ul>
	 */
	public DetailListAction() {
		super();
	}
	
	/* (non-Javadoc)
	 * @see jp.mosp.common.common.BaseAction#getSpecificVo()
	 */
	@Override
	protected BaseVo getSpecificVo() {
		return new DetailListVo();
	}
	
	/**
	 * ANVB<br>
	 * ڍׂ́ANXQƁB<br>
	 */
	public void action() throws Exception {
		// VO擾yѐݒ
		prepareVo();
		if (this.cmd.equals(CMD_SHOW)) {
			// ʕ\
			show();
		} else if (this.cmd.equals(CMD_SEARCH)) {
			// 
			search();
		} else if (this.cmd.equals(CMD_RE_SEARCH)) {
			// Č
			reSearch();
		} else if (this.cmd.equals(CMD_SORT)) {
			// \[g
			sort();
		} else if (this.cmd.equals(CMD_PAGE)) {
			// y[W
			page();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	/**
	 * ʕ\sB<br><br>
	 * @throws Exception 
	 */
	private void show() throws Exception {
		// RlNV擾
		getConnection();
		// VO擾
		DetailListVo vo = (DetailListVo)getVo();
		// VOtB[hݒ
		vo.setPltType  (String.valueOf(PayrollConst.DETAIL_TYPE_PT));
		vo.setTxtAbbr  ("");
		vo.setPltDelete(String.valueOf(MospConst.DELETE_FLAG_OFF));
	}
	
	/**
	 * sB
	 * @throws Exception 
	 */
	private void search() throws Exception {
		// VO擾
		DetailListVo vo = (DetailListVo)getVo();
		// p[^擾
		vo.setParams(request);
		// Xg擾
		getList();
	}
	
	/**
	 * 	ČsB
	 * @throws Exception 
	 */
	private void reSearch() throws Exception {
		// Xg擾
		getList();
	}
	
	/**
	 * \[gsB
	 * @throws Exception 
	 */
	private void sort() throws Exception {
		// VO擾
		DetailListVo vo = (DetailListVo)getVo();
		// \[gݒ
		vo.setSortKey(key1);
		vo.setSelectIndex(1);
		// Xg擾
		getList();
	}
	
	/**
	 * y[WsB
	 * @throws Exception 
	 */
	private void page() throws Exception {
		// VO擾
		DetailListVo vo = (DetailListVo)getVo();
		// y[Wݒ
		vo.setSelectIndex(Integer.parseInt(key1));
		// Xg擾
		getList();
	}
	
	/**
	 * Xg擾B
	 * @throws Exception 
	 */
	private void getList() throws Exception {
		// RlNV擾
		getConnection();
		// VO擾
		DetailListVo vo = (DetailListVo)getVo();
		// ׋敪Xg擾
		if (vo.getPltType().equals(PayrollConst.DETAIL_TYPE_PT)) {
			// ^Α
			getListPt();
		} else if (vo.getPltType().equals(PayrollConst.DETAIL_TYPE_PA)) {
			// ^x
			getListPa();
		} else if (vo.getPltType().equals(PayrollConst.DETAIL_TYPE_PD)) {
			// ^T
			getListPd();
		} else if (vo.getPltType().equals(PayrollConst.DETAIL_TYPE_PB)) {
			// ^
			getListPb();
		} else if (vo.getPltType().equals(PayrollConst.DETAIL_TYPE_PS)) {
			// ^v
			getListPs();
		} else if (vo.getPltType().equals(PayrollConst.DETAIL_TYPE_BA)) {
			// ܗ^x
			getListBa();
		} else if (vo.getPltType().equals(PayrollConst.DETAIL_TYPE_BD)) {
			// ܗ^T
			getListBd();
		} else if (vo.getPltType().equals(PayrollConst.DETAIL_TYPE_BS)) {
			// ܗ^v
			getListBs();
		}
		// Ώۂꍇ̃bZ[Wݒ
		if (vo.getCount() == 0) {
			vo.addErrMessage(MospUtility.getMessage(msg, MospConst.MSG_NO_DATA, ""));
		}
	}
	
	/**
	 * ^ΑӖאݒ胊Xg擾B
	 * @throws SQLException 
	 * @throws IllegalAccessException 
	 */
	private void getListPt() throws SQLException, IllegalAccessException {
		// VO擾
		DetailListVo vo = (DetailListVo)getVo();
		// DAO
		PmDetailPtDao dao = new PmDetailPtDao(cfg, cmd, aspUser, user, conn);
		// 擾
		vo.setCountAllData(dao.count(vo.getTxtAbbr(), vo.getPltDelete()));
		// 
		List<?> list = dao.find(
				vo.getTxtAbbr    (),
				vo.getPltDelete  (),
				getSortKey       (),
				vo.getIsAscending(),
				vo.getDataPerPage(),
				vo.getOffset     ()
		);
		// VOɐݒ
		vo.setFields(list);
	}
	
	/**
	 * ^xאݒ胊Xg擾B
	 * @throws SQLException 
	 * @throws IllegalAccessException 
	 */
	private void getListPa() throws SQLException, IllegalAccessException {
		// VO擾
		DetailListVo vo = (DetailListVo)getVo();
		// DAO
		PmDetailPaDao dao = new PmDetailPaDao(cfg, cmd, aspUser, user, conn);
		// 擾
		vo.setCountAllData(dao.count(vo.getTxtAbbr(), vo.getPltDelete()));
		// 
		List<?> list = dao.find(
				vo.getTxtAbbr    (),
				vo.getPltDelete  (),
				getSortKey       (),
				vo.getIsAscending(),
				vo.getDataPerPage(),
				vo.getOffset     ()
		);
		// VOɐݒ
		vo.setFields(list);
	}
	
	/**
	 * ^Tאݒ胊Xg擾B
	 * @throws SQLException 
	 * @throws IllegalAccessException 
	 */
	private void getListPd() throws SQLException, IllegalAccessException {
		// VO擾
		DetailListVo vo = (DetailListVo)getVo();
		// DAO
		PmDetailPdDao dao = new PmDetailPdDao(cfg, cmd, aspUser, user, conn);
		// 擾
		vo.setCountAllData(dao.count(vo.getTxtAbbr(), vo.getPltDelete()));
		// 
		List<?> list = dao.find(
				vo.getTxtAbbr    (),
				vo.getPltDelete  (),
				getSortKey       (),
				vo.getIsAscending(),
				vo.getDataPerPage(),
				vo.getOffset     ()
		);
		// VOɐݒ
		vo.setFields(list);
	}
	
	/**
	 * ^󖾍אݒ胊Xg擾B
	 * @throws SQLException 
	 * @throws IllegalAccessException 
	 */
	private void getListPb() throws SQLException, IllegalAccessException {
		// VO擾
		DetailListVo vo = (DetailListVo)getVo();
		// DAO
		PmDetailPbDao dao = new PmDetailPbDao(cfg, cmd, aspUser, user, conn);
		// 擾
		vo.setCountAllData(dao.count(vo.getTxtAbbr(), vo.getPltDelete()));
		// 
		List<?> list = dao.find(
				vo.getTxtAbbr    (),
				vo.getPltDelete  (),
				getSortKey       (),
				vo.getIsAscending(),
				vo.getDataPerPage(),
				vo.getOffset     ()
		);
		// VOɐݒ
		vo.setFields(list);
	}
	
	/**
	 * ^vאݒ胊Xg擾B
	 * @throws SQLException 
	 * @throws IllegalAccessException 
	 */
	private void getListPs() throws SQLException, IllegalAccessException {
		// VO擾
		DetailListVo vo = (DetailListVo)getVo();
		// DAO
		PmDetailPsDao dao = new PmDetailPsDao(cfg, cmd, aspUser, user, conn);
		// 擾
		vo.setCountAllData(dao.count(vo.getTxtAbbr(), vo.getPltDelete()));
		// 
		List<?> list = dao.find(
				vo.getTxtAbbr    (),
				vo.getPltDelete  (),
				getSortKey       (),
				vo.getIsAscending(),
				vo.getDataPerPage(),
				vo.getOffset     ()
		);
		// VOɐݒ
		vo.setFields(list);
	}

	/**
	 * ܗ^xאݒ胊Xg擾B
	 * @throws SQLException 
	 * @throws IllegalAccessException 
	 */
	private void getListBa() throws SQLException, IllegalAccessException {
		// VO擾
		DetailListVo vo = (DetailListVo)getVo();
		// DAO
		PmDetailBaDao dao = new PmDetailBaDao(cfg, cmd, aspUser, user, conn);
		// 擾
		vo.setCountAllData(dao.count(vo.getTxtAbbr(), vo.getPltDelete()));
		// 
		List<?> list = dao.find(
				vo.getTxtAbbr    (),
				vo.getPltDelete  (),
				getSortKey       (),
				vo.getIsAscending(),
				vo.getDataPerPage(),
				vo.getOffset     ()
		);
		// VOɐݒ
		vo.setFields(list);
	}
	
	/**
	 * ܗ^Tאݒ胊Xg擾B
	 * @throws SQLException 
	 * @throws IllegalAccessException 
	 */
	private void getListBd() throws SQLException, IllegalAccessException {
		// VO擾
		DetailListVo vo = (DetailListVo)getVo();
		// DAO
		PmDetailBdDao dao = new PmDetailBdDao(cfg, cmd, aspUser, user, conn);
		// 擾
		vo.setCountAllData(dao.count(vo.getTxtAbbr(), vo.getPltDelete()));
		// 
		List<?> list = dao.find(
				vo.getTxtAbbr    (),
				vo.getPltDelete  (),
				getSortKey       (),
				vo.getIsAscending(),
				vo.getDataPerPage(),
				vo.getOffset     ()
		);
		// VOɐݒ
		vo.setFields(list);
	}
	
	/**
	 * ܗ^vאݒ胊Xg擾B
	 * @throws SQLException 
	 * @throws IllegalAccessException 
	 */
	private void getListBs() throws SQLException, IllegalAccessException {
		// VO擾
		DetailListVo vo = (DetailListVo)getVo();
		// DAO
		PmDetailBsDao dao = new PmDetailBsDao(cfg, cmd, aspUser, user, conn);
		// 擾
		vo.setCountAllData(dao.count(vo.getTxtAbbr(), vo.getPltDelete()));
		// 
		List<?> list = dao.find(
				vo.getTxtAbbr    (),
				vo.getPltDelete  (),
				getSortKey       (),
				vo.getIsAscending(),
				vo.getDataPerPage(),
				vo.getOffset     ()
		);
		// VOɐݒ
		vo.setFields(list);
	}

	/**
	 * \[gL[擾B<br>
	 * @return \[gL[
	 */
	private String getSortKey() {
		// VO擾
		DetailListVo vo = (DetailListVo)getVo();
		// IL[擾
		String selectKey = vo.getSelectKey();
		// \[gL[擾
		String sortKey = PmDetailPaDao.COL_DETAIL_CODE;
		if (selectKey == null) {
			// 
		} else if (selectKey.equals("2")) {
			sortKey = PmDetailPaDao.COL_DETAIL_NAME;
		} else if (selectKey.equals("3")) {
			sortKey = PmDetailPaDao.COL_DETAIL_ABBR;
		} else if (selectKey.equals("4")) {
			sortKey = PmDetailPaDao.COL_DELETE_FLAG;
		}
		return sortKey;
	}

}
